/*Beef x Holstein trial code*/

X = Response variable (e.g. ADG, DMI, G:F);

/*Feedlot performance*/

Proc mixed data=BxHO Plots=all;
class Breed Pen Rep Block Day;
model X=Breed|Day;
random Pen(Block);
repeated Day/type = cs subject = Pen(Breed);
lsmeans Breed|Day/pdiff slice=(Breed Day);
run;

/*Morbidity and Mortality*/

Proc freq data = BxHO nlevels;
tables X*Breed/fisher;
run;

Proc glimmix data=BxHO Plots=residualpanel;
class Breed Pen Rep Block;
model X (event='1') = Breed/dist=binary ddfm = satterth;
lsmeans Breed/pdiff ilink;
run;

/*Carcass characteristics and economic analysis*/

proc mixed data=BxHO Plots = all;
class Breed Pen Rep Block;
model X=Breed;
random Pen(Block);
lsmeans Breed/pdiff;
run;

/*Quality grade*/

Proc freq data=BxHO nlevels;
tables X*Breed/fisher;
run;

Proc glimmix data=BxHO Plots=residualpanel;
class Breed Pen Rep Block;
model X (event='1')=Breed/dist=binary ddfm = satterth;
lsmeans Breed/pdiff ilink;
run;

/*Pricing scenarios*/

Proc mixed data=BxHO Plots=all;
class Breed Pen Rep Block ID PricingScenario;
model X= PricingScenario;
random Pen (Block);
lsmeans PricingScenario/pdiff adjust = Tukey;
run;

Proc glm data=BxHO;
class Breed Pen Rep Block ID PricingScenario;
model X= PricingScenario;
means PricingScenario/Tukey;
means PricingScenario/duncan waller;
run;
